package ru.yandex.chemodan.app.lentaloader.lenta;

import java.util.NoSuchElementException;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Either;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;

/**
 * @author dbrylev
 */
public class CachedOrLoadedBlock {
    public final Either<LentaBlockRecord, DataRecord> cachedOrLoaded;

    public CachedOrLoadedBlock(Either<LentaBlockRecord, DataRecord> cachedOrLoaded) {
        this.cachedOrLoaded = cachedOrLoaded;
    }

    public static CachedOrLoadedBlock cached(LentaBlockRecord record) {
        return new CachedOrLoadedBlock(Either.left(record));
    }

    public static CachedOrLoadedBlock loaded(DataRecord record) {
        return new CachedOrLoadedBlock(Either.right(record));
    }

    public LentaBlockRecord toBlockRecord() {
        return cachedOrLoaded.fold(r -> r, LentaBlockRecord::fromDataRecord);
    }

    public String getId() {
        return cachedOrLoaded.fold(r -> r.id, DataRecord::getRecordId);
    }

    public LentaBlockIdAndType getIdAndType() {
        return cachedOrLoaded.fold(LentaBlockRecord::getIdAndType, LentaBlockIdAndType::fromDataRecord);
    }

    public Instant getMTime() {
        return cachedOrLoaded.fold(r -> r.mTime, LentaBlockRecord.Fields.MTIME::get);
    }

    public LentaRecordType getType() {
        return cachedOrLoaded.fold(r -> r.type, LentaBlockRecord.Fields.TYPE::get);
    }

    public String getGroupKey() {
        return cachedOrLoaded.fold(r -> r.groupKey, LentaBlockRecord.Fields.GROUP_KEY::get);
    }

    public String getCollectionIdOrCached() {
        return cachedOrLoaded.rightO().map(DataRecord::getCollectionId).getOrElse("cached");
    }

    public boolean isCached() {
        return cachedOrLoaded.isLeft();
    }

    public DataRecord asLoaded() {
        return cachedOrLoaded.rightO().getOrThrow(() -> new NoSuchElementException("Cached " + getIdAndType()));
    }

    public LentaBlockRecord asCached() {
        return cachedOrLoaded.leftO().getOrThrow(() -> new NoSuchElementException("Loaded " + getIdAndType()));
    }
}
