package ru.yandex.chemodan.app.lentaloader.lenta;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.DataColumn;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.DataCondition;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class FieldPredicate {

    public final String field;
    public final Operator op;
    public final Option<String> value;
    @BenderPart(wrapperName = "values")
    public final Option<SetF<String>> values;

    private FieldPredicate(String field, Operator op, Option<String> value, Option<SetF<String>> values) {
        this.field = field;
        this.op = op;
        this.value = value;
        this.values = values;
    }

    public static Field field(RecordField<String> field) {
        return new Field(field.name);
    }

    public static Field groupKey() {
        return field(LentaBlockRecord.Fields.GROUP_KEY);
    }

    public DataCondition toDataCondition() {
        if (op == Operator.EQUALS) {
            return DataColumn.string(field).eq(value.getOrThrow(() -> new IllegalStateException("Cannot use the 'eq' operation with empty value")));
        }
        if (op == Operator.STARTS_WITH) {
            return DataColumn.string(field).startsWith(value.getOrThrow(() -> new IllegalStateException("Cannot use the 'startsWith' operation with empty value")));
        }
        if (op == Operator.IN) {
            return DataColumn.string(field).inSet(values.getOrThrow(() -> new IllegalStateException("Cannot use the 'in' operation with empty values")));
        }
        throw new IllegalStateException("Unexpected operator: " + op);
    }

    public static class Field {
        private final String name;

        private Field(String name) {
            this.name = name;
        }

        public FieldPredicate eq(String value) {
            return new FieldPredicate(name, Operator.EQUALS, Option.of(value), Option.empty());
        }

        public FieldPredicate startsWith(String value) {
            return new FieldPredicate(name, Operator.STARTS_WITH, Option.of(value), Option.empty());
        }

        public FieldPredicate in(SetF<String> values) {
            return new FieldPredicate(name, Operator.IN, Option.empty(), Option.of(values));
        }
    }

    public enum Operator implements StringEnum {
        EQUALS, STARTS_WITH, IN;

        public static final StringEnumResolver<Operator> R = StringEnumResolver.r(Operator.class);

        @Override
        public String value() {
            return CamelWords.parse(name()).toXmlName();
        }
    }
}
