package ru.yandex.chemodan.app.lentaloader.lenta;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;

/**
 * @author dbrylev
 */
public class FindOrCreateResult {
    public final LentaBlockRecord record;
    public final Option<CachedOrLoadedBlock> foundBlock;
    public final Option<ActionReason> ignoreReason;
    public final Status status;

    public FindOrCreateResult(
            LentaBlockRecord record,
            Option<CachedOrLoadedBlock> foundBlock,
            Option<ActionReason> ignoreReason, Status status)
    {
        this.record = record;
        this.foundBlock = foundBlock;
        this.ignoreReason = ignoreReason;
        this.status = status;
    }

    public static FindOrCreateResult found(CachedOrLoadedBlock block) {
        return new FindOrCreateResult(block.toBlockRecord(), Option.of(block), Option.empty(), Status.FOUND);
    }

    public static FindOrCreateResult created(LentaBlockRecord record) {
        return new FindOrCreateResult(record, Option.empty(), Option.empty(), Status.CREATED);
    }

    public static FindOrCreateResult ignored(LentaBlockRecord record, ActionReason reason) {
        return new FindOrCreateResult(record, Option.empty(), Option.of(reason), Status.IGNORED);
    }

    public boolean isFound() {
        return status == Status.FOUND;
    }

    public boolean isCreated() {
        return status == Status.CREATED;
    }

    public boolean isIgnored() {
        return status == Status.IGNORED;
    }

    public String getRecordId() {
        return record.id;
    }

    public enum Status {
        FOUND,
        CREATED,
        IGNORED,
    }
}
