package ru.yandex.chemodan.app.lentaloader.lenta;

import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;

/**
 * @author dbrylev
 */
public class LentaBlockIdAndType {
    public final String id;
    public final LentaRecordType type;

    public LentaBlockIdAndType(String id, LentaRecordType type) {
        this.id = id;
        this.type = type;
    }

    public static LentaBlockIdAndType fromDataRecord(DataRecord record) {
        return new LentaBlockIdAndType(record.getRecordId(), LentaBlockRecord.Fields.TYPE.get(record));
    }

    public static LentaBlockIdAndType noId(LentaRecordType type) {
        return new LentaBlockIdAndType("", type);
    }

    @Override
    public String toString() {
        return type + "/" + id;
    }
}
