package ru.yandex.chemodan.app.lentaloader.lenta;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.limit.FolderBlockData;
import ru.yandex.chemodan.app.lentaloader.lenta.update.DeleteHandler;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockCreateData;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockModifyData;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockUpdateData;
import ru.yandex.chemodan.app.lentaloader.lenta.update.UpdateOrDeleteHandler;
import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.lentaloader.log.ReasonedAction;

/**
 * @author dbrylev
 */
public interface LentaManager {

    Option<LentaBlockRecord> findBlock(DataApiUserId uid, String blockId, ActionInfo actionInfo);

    ListF<LentaBlockRecord> findBlocks(
            DataApiUserId uid, LentaRecordType type, FieldPredicate filter, ActionInfo actionInfo);

    Option<LentaBlockRecord> findMostRecentBlock(
            DataApiUserId uid, LentaRecordType type, FieldPredicate filter, ActionInfo actionInfo);

    FindOrCreateResult findOrCreateBlock(DataApiUserId uid, LentaBlockCreateData data, ActionInfo actionInfo);

    boolean findAndUpdateBlock(DataApiUserId uid, LentaBlockUpdateData data, ActionInfo actionInfo);

    boolean findCachedAndUpdateBlock(DataApiUserId uid, LentaBlockUpdateData data, ActionInfo actionInfo);

    FindOrCreateResult findAndUpdateOrCreateBlock(DataApiUserId uid, LentaBlockModifyData data, ActionInfo actionInfo);

    FindOrCreateResult findCachedAndUpdateOrCreateBlock(
            DataApiUserId uid, LentaBlockModifyData data, ActionInfo actionInfo);

    Option<String> findAndPinOrCreatePinnedBlock(DataApiUserId uid, LentaBlockCreateData data, ActionInfo actionInfo);

    void createAndDeleteBlocks(
            DataApiUserId uid, ListF<FolderBlockData> datas, ListF<String> deleteIds, ReasonedAction actionInfo);

    boolean updateBlock(DataApiUserId uid, String blockId, LentaBlockUpdateData data, ActionInfo actionInfo);

    void updateOrDeleteBlock(DataApiUserId uid, String blockId, UpdateOrDeleteHandler handler, ActionInfo actionInfo);

    Option<FindOrCreateResult> unpinBlockIfPinned(DataApiUserId uid, String blockId, ActionInfo actionInfo);

    Option<FindOrCreateResult> unpinBlockIfPinned(
            DataApiUserId uid, LentaRecordType type, String groupKey, ActionInfo actionInfo);

    void deleteBlock(DataApiUserId uid, String blockId, ReasonedAction actionInfo);

    void deleteBlock(DataApiUserId uid, String blockId, DeleteHandler handler, ActionInfo actionInfo);

    void deleteMostRecentBlock(
            DataApiUserId uid, LentaRecordType type, String groupKey, DeleteHandler handler, ActionInfo actionInfo);

    void deleteBlocks(DataApiUserId uid, LentaRecordType type, String groupKey, ReasonedAction actionInfo);

    void findAndUpThrottledLatestBlock(DataApiUserId uid, LentaRecordType type, String groupKey, ActionInfo actionInfo);

    void updateAndUpOrDeleteBlockDelayed(DataApiUserId uid, LentaBlockIdAndType block, ActionInfo actionInfo);

    default void updateAndUpOrDeleteBlockDelayed(
            DataApiUserId uid, String blockId, LentaRecordType type, ActionInfo actionInfo)
    {
        updateAndUpOrDeleteBlockDelayed(uid, new LentaBlockIdAndType(blockId, type), actionInfo);
    }

    void unpinBlockDelayed(DataApiUserId uid, LentaBlockIdAndType block, ActionInfo actionInfo);

    void deleteEmptyBlockDelayed(DataApiUserId uid, LentaBlockIdAndType block, ReasonedAction actionInfo);

    void deleteOrUpdateBlockDelayed(DataApiUserId uid, LentaBlockIdAndType block, Duration delay, ReasonedAction actionInfo);

    void deleteOrUpdateBlocksAsync(
            DataApiUserId uid, LentaRecordType type, FieldPredicate filter, ReasonedAction actionInfo);

    int deleteEldestBlocks(DataApiUserId uid, int limit, ReasonedAction actionInfo);
}
