package ru.yandex.chemodan.app.lentaloader.lenta;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class LentaNextIndexRecord {
    public static final String ID = "next_index";

    public final String id = ID;
    public final LentaRecordType type = LentaRecordType.NEXT_INDEX;
    public final String collectionId;

    public LentaNextIndexRecord(String collectionId) {
        this.collectionId = collectionId;
    }

    public static LentaNextIndexRecord fromDataRecord(DataRecord rec) {
        Validate.equals(ID, rec.getRecordId());
        return new LentaNextIndexRecord(Fields.COLLECTION_ID.get(rec));
    }

    public MapF<String, DataField> toData() {
        return Cf.toMap(Cf.list(Fields.TYPE.toData(type), Fields.COLLECTION_ID.toData(collectionId)));
    }

    public interface Fields {
        RecordField<LentaRecordType> TYPE = RecordField.stringEnum("type", LentaRecordType.class);
        RecordField<String> COLLECTION_ID = RecordField.string("collection_id");
    }
}
