package ru.yandex.chemodan.app.lentaloader.lenta;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author dbrylev
 */
public enum LentaRecordType implements StringEnum {
    ALBUM_OWNED("album_owned"),
    ALBUM_PUBLIC("album_public"),
    CONTENT_BLOCK("content_block", true),
    FOLDER_BLOCK("folder_block"),
    FOLDER_CREATION("folder_creation"),
    GENERIC_BLOCK("generic_block"),
    PUBLIC_RESOURCE("public_resource"),
    PUBLIC_RESOURCE_OWNED("public_resource_owned"),
    SHARED_RESOURCE("shared_resource"),
    PHOTO_REMIND_BLOCK("photo_remind_block", true),
    PHOTO_REMIND_HIDDEN_BLOCK("photo_remind_hidden_block", true),
    PHOTO_SELECTION_BLOCK("photo_selection_block", true),
    SHARED_FOLDER("shared_folder"),
    SHARED_FOLDER_INVITE("shared_folder_invite", true),
    NEXT_INDEX("next_index"),
    ;

    public static final StringEnumResolver<LentaRecordType> R = StringEnumResolver.r(LentaRecordType.class);

    private final String value;
    private final boolean timeLimited;

    LentaRecordType(String value) {
        this(value, false);
    }

    LentaRecordType(String value, boolean timeLimited) {
        this.value = value;
        this.timeLimited = timeLimited;
    }

    @Override
    public String value() {
        return value;
    }

    public boolean isTimeLimited() {
        return timeLimited;
    }
}
