package ru.yandex.chemodan.app.lentaloader.lenta;

import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockBaseData;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class UserBlockGroupKeyAndType extends DefaultObject {

    public final DataApiUserId uid;
    public final String groupKey;
    public final LentaRecordType type;

    public UserBlockGroupKeyAndType(DataApiUserId uid, LentaBlockBaseData base) {
        this(uid, base.groupKey, base.type);
    }

    public UserBlockGroupKeyAndType(DataApiUserId uid, DataRecord record) {
        this(uid, LentaBlockRecord.Fields.GROUP_KEY.get(record), LentaBlockRecord.Fields.TYPE.get(record));
    }

    public UserBlockGroupKeyAndType(DataApiUserId uid, LentaBlockRecord record) {
        this(uid, record.groupKey, record.type);
    }

    public UserBlockGroupKeyAndType(DataApiUserId uid, CachedOrLoadedBlock block) {
        this(uid, block.getGroupKey(), block.getType());
    }

    public UserBlockGroupKeyAndType(DataApiUserId uid, String groupKey, LentaRecordType type) {
        this.uid = uid;
        this.groupKey = groupKey;
        this.type = type;
    }
}
