package ru.yandex.chemodan.app.lentaloader.lenta.limit;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleRecordId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.chemodan.eventlog.events.MpfsPath;
import ru.yandex.chemodan.mpfs.MpfsUid;

/**
 * @author dbrylev
 */
public class ContentCreature {

    public final String blockId;
    public final String collectionId;

    public final MpfsPath path;
    public final Option<String> mediaType;
    public final MpfsUid modifierUid;

    public final Option<Integer> blocksCount;
    public final Instant cTime;

    public ContentCreature(
            String blockId, String collectionId,
            MpfsPath path, Option<String> mediaType, MpfsUid modifierUid,
            Option<Integer> blocksCount, Instant cTime)
    {
        this.blockId = blockId;
        this.collectionId = collectionId;
        this.path = path;
        this.mediaType = mediaType;
        this.modifierUid = modifierUid;
        this.blocksCount = blocksCount;
        this.cTime = cTime;
    }

    public static ContentCreature fromDataRecord(DataRecord rec) {
        return new ContentCreature(
                rec.getRecordId(),
                rec.getCollectionId(),
                MpfsPath.parseDir(Fields.PATH.get(rec)),
                Fields.MEDIA_TYPE.getO(rec),
                MpfsUid.parse(Fields.MODIFIER_UID.get(rec)),
                Fields.BLOCKS_COUNT.getO(rec),
                Fields.CTIME.get(rec));
    }

    public MapF<String, DataField> toData() {
        ListF<Tuple2<String, DataField>> data = Cf.list(
                Fields.PATH.toData(path.value),
                Fields.CTIME.toData(cTime),
                Fields.MODIFIER_UID.toData(modifierUid.getRawValue()));

        return Cf.toMap(data
                .plus(mediaType.map(Fields.MEDIA_TYPE::toData))
                .plus(blocksCount.map(Fields.BLOCKS_COUNT::toData)));
    }

    public ContentCreature withBlocksCount(int blocksCount) {
        return new ContentCreature(blockId, collectionId, path, mediaType, modifierUid, Option.of(blocksCount), cTime);
    }

    public boolean isFolder() {
        return collectionId.equals(LentaLimitManagerImpl.FOLDER_BLOCKS);
    }

    public SimpleRecordId getRecordId() {
        return new SimpleRecordId(collectionId, blockId);
    }

    public UserContentPath toUserContentPath(DataApiUserId uid) {
        return new UserContentPath(uid, path, modifierUid);
    }

    public interface Fields {
        RecordField<String> PATH = RecordField.string("path");
        RecordField<String> MEDIA_TYPE = RecordField.string("media_type");
        RecordField<String> MODIFIER_UID = RecordField.string("modifier_uid");
        RecordField<Integer> BLOCKS_COUNT = RecordField.intNumber("blocks_count");
        RecordField<Instant> CTIME = RecordField.instant("ctime");
    }
}
