package ru.yandex.chemodan.app.lentaloader.lenta.limit;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.blocks.FolderBlockFields;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;
import ru.yandex.chemodan.eventlog.events.MpfsPath;
import ru.yandex.chemodan.mpfs.MpfsResourceId;
import ru.yandex.chemodan.mpfs.MpfsUid;

/**
 * @author dbrylev
 */
public class FolderBlockData {

    public final String blockId;
    public final MpfsPath path;
    public final MpfsResourceId resourceId;
    public final MpfsUid modifierUid;
    public final int blocksCount;

    public FolderBlockData(
            String blockId, MpfsPath path, MpfsResourceId resourceId,
            MpfsUid modifierUid, int blocksCount)
    {
        this.blockId = blockId;
        this.path = path;
        this.resourceId = resourceId;
        this.modifierUid = modifierUid;
        this.blocksCount = blocksCount;
    }

    public LentaBlockRecord toRecord(long order) {
        String groupKey = resourceId.serialize() + ":" + modifierUid.getRawValue();

        MapF<String, DataField> specific = Cf.toMap(Cf.list(
                FolderBlockFields.FOLDER_ID.toData(resourceId.serialize()),
                FolderBlockFields.MODIFIER_UID.toData(modifierUid.getRawValue())));

        return new LentaBlockRecord(
                blockId, order, LentaRecordType.FOLDER_BLOCK, groupKey,
                Option.empty(), Instant.now(), Option.empty(), specific);
    }
}
