package ru.yandex.chemodan.app.lentaloader.lenta.limit;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.eventlog.events.MpfsPath;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class UserContentPath extends DefaultObject {

    public final DataApiUserId uid;
    public final MpfsPath path;
    public final Option<MpfsUid> modifierUid;

    public UserContentPath(DataApiUserId uid, MpfsPath path, MpfsUid modifierUid) {
        this.uid = uid;
        this.path = path;
        this.modifierUid = Option.when(!modifierUid.getRawValue().equals(uid.serialize()), modifierUid);
    }
}
