package ru.yandex.chemodan.app.lentaloader.lenta.update;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;
import ru.yandex.chemodan.app.lentaloader.log.DataOrRefusal;

/**
 * @author dbrylev
 */
public interface CreateHandler {
    Action getAction(LentaBlockRecord rec);

    static Action create(MapF<String, DataField> specific) {
        return new Action(DataOrRefusal.data(specific));
    }

    static Action ignore(ActionReason reason) {
        return new Action(DataOrRefusal.refusal(reason));
    }

    class Action {
        public final DataOrRefusal<MapF<String, DataField>> specific;

        private Action(DataOrRefusal<MapF<String, DataField>> specific) {
            this.specific = specific;
        }
    }
}
