package ru.yandex.chemodan.app.lentaloader.lenta.update;

import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;

/**
 * @author dbrylev
 */
public interface DeleteHandler {
    Action getAction(LentaBlockRecord rec);

    static Action ignore() {
        return new Ignore();
    }

    static Action delete(ActionReason reason) {
        return new Delete(reason);
    }

    class Action {}

    class Ignore extends Action {}

    class Delete extends Action {
        public final ActionReason reason;

        public Delete(ActionReason reason) {
            this.reason = reason;
        }
    }
}
