package ru.yandex.chemodan.app.lentaloader.lenta.update;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;

/**
 * @author dbrylev
 */
public class LentaBlockCreateData {
    public final LentaBlockBaseData base;
    public final CreateHandler handler;

    public LentaBlockCreateData(
            LentaRecordType type, String groupKey, CreateHandler handler)
    {
        this(new LentaBlockBaseData(type, groupKey), handler);
    }

    public LentaBlockCreateData(
            LentaRecordType type, String groupKey, MapF<String, DataField> specific)
    {
        this(new LentaBlockBaseData(type, groupKey), rec -> CreateHandler.create(specific));
    }

    public LentaBlockCreateData(LentaBlockBaseData base, CreateHandler handler) {
        this.base = base;
        this.handler = handler;
    }
}
