package ru.yandex.chemodan.app.lentaloader.lenta.update;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;

/**
 * @author dbrylev
 */
public class LentaBlockModifyData {
    public final LentaBlockBaseData base;

    public final CreateHandler createHandler;
    public final UpdateHandler updateHandler;

    public LentaBlockModifyData(
            LentaRecordType type, String groupKey,
            CreateHandler createHandler, UpdateHandler updateHandler)
    {
        this(new LentaBlockBaseData(type, groupKey), createHandler, updateHandler);
    }

    public LentaBlockModifyData(LentaBlockBaseData base, CreateHandler createHandler, UpdateHandler updateHandler) {
        this.base = base;
        this.createHandler = createHandler;
        this.updateHandler = updateHandler;
    }

    public static LentaBlockModifyData createOrUpdate(
            LentaRecordType type, String groupKey, MapF<String, DataField> specific)
    {
        return new LentaBlockModifyData(type, groupKey,
                rec -> CreateHandler.create(specific), rec -> UpdateHandler.update(specific));
    }

    public static LentaBlockModifyData createOrUpdateAndUp(
            LentaRecordType type, String groupKey, MapF<String, DataField> specific)
    {
        return new LentaBlockModifyData(type, groupKey,
                rec -> CreateHandler.create(specific), rec -> UpdateHandler.updateAndUp(specific));
    }

    public static LentaBlockModifyData createOrUpdateAndUpDelayed(
            LentaRecordType type, String groupKey, MapF<String, DataField> specificCreate)
    {
        return new LentaBlockModifyData(type, groupKey,
                rec -> CreateHandler.create(specificCreate), rec -> UpdateHandler.updateAndUpDelayed());
    }

    public static LentaBlockModifyData createOrUpdateAndUpThrottled(
            LentaRecordType type, String groupKey, MapF<String, DataField> specificCreateOrInplaceUpdate)
    {
        return new LentaBlockModifyData(type, groupKey,
                rec -> CreateHandler.create(specificCreateOrInplaceUpdate),
                rec -> UpdateHandler.updateAndUpThrottled(specificCreateOrInplaceUpdate));
    }

    public LentaBlockCreateData getCreateData() {
        return new LentaBlockCreateData(base, createHandler);
    }

    public LentaBlockUpdateData getUpdateData() {
        return new LentaBlockUpdateData(base, updateHandler);
    }
}
