package ru.yandex.chemodan.app.lentaloader.lenta.update;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;

/**
 * @author dbrylev
 */
public class LentaBlockUpdateData {
    public final LentaBlockBaseData base;
    public final UpdateHandler handler;

    public LentaBlockUpdateData(
            LentaRecordType type, String groupKey, UpdateHandler handler)
    {
        this(new LentaBlockBaseData(type, groupKey), handler);
    }

    public LentaBlockUpdateData(LentaBlockBaseData base, UpdateHandler handler) {
        this.base = base;
        this.handler = handler;
    }

    public static LentaBlockUpdateData update(
            LentaRecordType type, String groupKey, MapF<String, DataField> specific)
    {
        return new LentaBlockUpdateData(type, groupKey, rec -> UpdateHandler.update(specific));
    }

    public static LentaBlockUpdateData updateAndUp(
            LentaRecordType type, String groupKey, MapF<String, DataField> specific)
    {
        return new LentaBlockUpdateData(type, groupKey, rec -> UpdateHandler.updateAndUp(specific));
    }

    public static LentaBlockUpdateData updateAndUpDelayed(LentaRecordType type, String groupKey) {
        return new LentaBlockUpdateData(type, groupKey, rec -> UpdateHandler.updateAndUpDelayed());
    }

    public static LentaBlockUpdateData updateAndUpThrottled(
            LentaRecordType type, String groupKey, MapF<String, DataField> specificUpdateInplace) {
        return new LentaBlockUpdateData(type, groupKey, rec -> UpdateHandler.updateAndUpThrottled(specificUpdateInplace));
    }
}
