package ru.yandex.chemodan.app.lentaloader.lenta.update;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;

/**
 * @author dbrylev
 */
public interface UpdateHandler {
    Action getAction(LentaBlockRecord rec);

    static Action update(MapF<String, DataField> specific) {
        return new Update(specific, false, false);
    }

    static Action updateAndUp(MapF<String, DataField> specific) {
        return new Update(specific, true, false);
    }

    static Action updateAndUpThrottled(MapF<String, DataField> specific) {
        return new Update(specific, true, true);
    }

    static Action updateAndUpThrottled(Supplier<MapF<String, DataField>> specific) {
        return new Update(specific, true, true);
    }

    static Action updateAndUpDelayed() {
        return new Delayed();
    }

    static Action ignore(ActionReason reason) {
        return new Ignore(reason);
    }

    class Action {}

    class Delayed extends Action {}

    class Ignore extends Action {
        public final ActionReason reason;

        public Ignore(ActionReason reason) {
            this.reason = reason;
        }
    }

    class Update extends Action {
        public final Supplier<MapF<String, DataField>> specific;
        public final boolean updateAndUp;
        public final boolean throttled;

        private Update(MapF<String, DataField> specific, boolean updateAndUp, boolean throttled) {
            this(() -> specific, updateAndUp, throttled);
        }

        private Update(Supplier<MapF<String, DataField>> specific, boolean updateAndUp, boolean throttled) {
            this.specific = specific;
            this.updateAndUp = updateAndUp;
            this.throttled = throttled;
        }
    }
}
