package ru.yandex.chemodan.app.lentaloader.lenta.update;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;

/**
 * @author dbrylev
 */
public interface UpdateOrDeleteHandler {
    Action getAction(LentaBlockRecord rec);

    static Action delete(ActionReason reason) {
        return new Delete(reason);
    }

    static Action ignore() {
        return new Ignore();
    }

    static Action update(LentaBlockBaseData base, MapF<String, DataField> specific) {
        return new Update(new LentaBlockUpdateData(base, rec -> UpdateHandler.update(specific)));
    }

    static Action updateAndUp(LentaBlockBaseData base, MapF<String, DataField> specific) {
        return new Update(new LentaBlockUpdateData(base, rec -> UpdateHandler.updateAndUp(specific)));
    }

    class Action {}

    class Ignore extends Action {}

    class Delete extends Action {
        public ActionReason reason;

        public Delete(ActionReason reason) {
            this.reason = reason;
        }
    }

    class Update extends Action {
        public final LentaBlockUpdateData data;

        private Update(LentaBlockUpdateData data) {
            this.data = data;
        }
    }
}
