package ru.yandex.chemodan.app.lentaloader.log;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.util.bender.BenderUtils;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class ActionEventData extends DefaultObject implements LogDataProvider {
    public final EventType type;
    public final Instant time;
    public final Tuple2List<String, String> data;

    public ActionEventData(EventType type, Instant time, Tuple2List<String, String> data) {
        this.type = type;
        this.time = time;
        this.data = data;
    }

    @Override
    public Tuple2List<String, String> logData() {
        Tuple2List<String, String> result = Tuple2List.<String, String>tuple2List()
                .plus1("action_event", type.value())
                .plus1("action_time", LentaEventLogger.dateTimeFormat.print(time));

        return data.isNotEmpty()
                ? result.plus1("action_data", BenderUtils.serialize(new JsonObject(data.map2(JsonString::valueOf))))
                : result;
    }
}
