package ru.yandex.chemodan.app.lentaloader.log;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class ActionInfo extends DefaultObject implements LogDataProvider {

    public final Instant now;
    public final ActionSource source;
    public final Option<ActionEventData> event;

    private ActionInfo(Instant now, ActionSource source, Option<ActionEventData> event) {
        this.now = now;
        this.source = source;
        this.event = event;
    }

    public static ActionInfo internal(ActionSource source) {
        return internal(Instant.now(), source);
    }

    public static ActionInfo internal(Instant now, ActionSource source) {
        return new ActionInfo(now, source, Option.empty());
    }

    public static ActionInfo logEvent(ActionEventData event, ActionSource source) {
        return new ActionInfo(Instant.now(), source, Option.of(event));
    }

    public static ActionInfo asyncEvent(
            Option<ActionEventData> event, Instant now, ActionSource source)
    {
        return new ActionInfo(now, source, event);
    }

    public ReasonedAction withReason(ActionReason reason) {
        return new ReasonedAction(this, reason);
    }

    public ActionInfo withSource(ActionSource source) {
        return new ActionInfo(now, source, event);
    }

    public ActionInfo withParameter(String key, String value) {
        return withSource(source.withParameter(key, value));
    }

    public Option<ActionEventData> getActionEvent() {
        return event;
    }

    public Option<Instant> getActionTime() {
        return event.map(e -> e.time);
    }

    @Override
    public Tuple2List<String, String> logData() {
        return source.logData().plus(event.map(LogDataProvider::logData).getOrElse(Tuple2List.tuple2List()));
    }
}
