package ru.yandex.chemodan.app.lentaloader.log;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.bazinga.impl.FullJobId;
import ru.yandex.misc.lang.CamelWords;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public abstract class ActionSource extends DefaultObject implements LogDataProvider {

    public static ActionSource test() {
        return new Test();
    }

    public static ActionSource lentaApi() {
        return new LentaApi();
    }

    public static ActionSource logBroker() {
        return new LogBroker();
    }

    public static ActionSource photoReminders() {
        return new PhotoReminders();
    }

    public static ActionSource notifier() {
        return new Notifier();
    }

    public static ActionSource bazingaTask(FullJobId jobId) {
        return new BazingaTask(jobId);
    }

    public static ActionSource celeryTask(FullJobId jobId) {
        return new CeleryTask(jobId);
    }

    public ActionSource withParameter(String name, String value) {
        return new ActionSourceWithParameter(this, name, value);
    }

    @Override
    public Tuple2List<String, String> logData() {
        return Tuple2List.fromPairs("action_source", CamelWords.parse(getClass().getSimpleName()).toXmlName());
    }

    private static class Test extends ActionSource {}

    private static class LentaApi extends ActionSource {}

    private static class LogBroker extends ActionSource {}

    private static class PhotoReminders extends ActionSource {}

    private static class Notifier extends ActionSource {}

    private static class BazingaTask extends ActionSource {
        public final FullJobId jobId;

        public BazingaTask(FullJobId jobId) {
            this.jobId = jobId;
        }

        @Override
        public Tuple2List<String, String> logData() {
            return super.logData().plus1("task", jobId.toSerializedString());
        }
    }

    private static class CeleryTask extends ActionSource {
        public final FullJobId jobId;

        public CeleryTask(FullJobId jobId) {
            this.jobId = jobId;
        }

        @Override
        public Tuple2List<String, String> logData() {
            return super.logData().plus1("task", jobId.toSerializedString());
        }
    }

    private static class ActionSourceWithParameter extends ActionSource {
        public final ActionSource source;
        public final String key;
        public final String value;

        public ActionSourceWithParameter(ActionSource source, String key, String value) {
            this.source = source;
            this.key = key;
            this.value = value;
        }

        @Override
        public Tuple2List<String, String> logData() {
            return source.logData().plus1(key, value);
        }
    }
}
