package ru.yandex.chemodan.app.lentaloader.log;

import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.io.IoFunction0;
import ru.yandex.misc.io.IoFunction0V;

/**
 * @author dbrylev
 */
public class ActionSourceHolder {

    private static final ThreadLocalX<ActionSource> action = new ThreadLocalX<>();

    public static ActionSource getOrThrow() {
        return action.getO().getOrThrow("No action source provided");
    }

    public static void set(ActionSource source) {
        action.set(source);
    }

    public static void remove() {
        action.remove();
    }

    public static void invokeWith(ActionSource source, IoFunction0V function) {
        invokeWithResult(source, () -> {function.apply(); return 0;});
    }

    public static <V> V invokeWithResult(ActionSource source, IoFunction0<V> function) {
        set(source);
        try {
            return function.apply();
        } finally {
            remove();
        }
    }
}
