package ru.yandex.chemodan.app.lentaloader.log;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;

/**
 * @author dbrylev
 */
public class DataOrRefusal<T> {
    private final Either<T, ActionReason> either;

    public DataOrRefusal(Either<T, ActionReason> either) {
        this.either = either;
    }

    public static <T> DataOrRefusal<T> refusal(ActionReason reason) {
        return new DataOrRefusal<>(Either.right(reason));
    }

    public static <T> DataOrRefusal<T> data(T data) {
        return new DataOrRefusal<>(Either.left(data));
    }

    public static <T> DataOrRefusal<T> someOrRefusal(Option<T> dataO, ActionReason reason) {
        return dataO.isPresent() ? data(dataO.get()) : refusal(reason);
    }

    public boolean isRefusal() {
        return either.isRight();
    }

    public T getData() {
        return either.getLeft();
    }

    public Option<T> getDataO() {
        return either.leftO();
    }

    public ActionReason getRefusalReason() {
        return either.getRight();
    }

    public <B> DataOrRefusal<B> map(Function<? super T, B> mapper) {
        return new DataOrRefusal<>(Either.fromOptions(either.leftO().map(mapper), either.rightO()));
    }

    public DataOrRefusal<T> matchOrRefusal(Function1B<? super T> matcher, ActionReason reason) {
        return either.leftO().filter(matcher).isPresent()
                ? data(either.getLeft())
                : refusal(either.rightO().getOrElse(reason));
    }

    public T getOrElse(T value) {
        return either.leftO().getOrElse(value);
    }
}
