package ru.yandex.chemodan.app.lentaloader.log;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
public class LentaBlockEventsCache {
    private static final ThreadLocal<ListF<LentaBlockEvent>> events = new ThreadLocal<>();

    public static void addIfNeeded(LentaBlockEvent event) {
        Option.ofNullable(events.get()).forEach(list -> list.add(event));
    }

    public static ListF<LentaBlockEvent> executeAndGetBlocks(Runnable action) {
        events.set(Cf.arrayList());
        try {
            action.run();
            return Option.ofNullable(events.get()).getOrElse(Cf.list());
        } finally {
            events.remove();
        }
    }
}
