package ru.yandex.chemodan.app.lentaloader.log;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.log.EventsTskvLogPatternLayout;
import ru.yandex.chemodan.log.TskvLoggerPatterned;
import ru.yandex.chemodan.util.bender.BenderUtils;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonBoolean;
import ru.yandex.commune.json.JsonNull;
import ru.yandex.commune.json.JsonNumber;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author dbrylev
 */
public class LentaEventLogger {
    public static final TskvLoggerPatterned logger = new TskvLoggerPatterned(
            "lenta-events", new EventsTskvLogPatternLayout("ydisk-lenta-events-log"));

    public static final DateTimeFormatter dateTimeFormat =
            DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(MoscowTime.TZ);

    public static String serializeToJson(MapF<String, DataField> data) {
        return BenderUtils.serialize(new JsonObject(data.entries().map2(LentaEventLogger::getJsonValue)));
    }

    private static JsonValue getJsonValue(DataField f) {
        switch (f.fieldType) {
            case NULL: return JsonNull.NULL;
            case STRING: return JsonString.valueOf(f.stringValue());
            case BOOLEAN: return JsonBoolean.valueOf(f.booleanValue());
            case INTEGER: return JsonNumber.valueOf(f.integerValue());
            case DECIMAL: return JsonNumber.valueOf(f.decimalValue());
            case TIMESTAMP: return JsonString.valueOf(dateTimeFormat.print(f.timestampValue()));
            case DATETIME: return JsonString.valueOf(dateTimeFormat.print(f.dateTimeValue()));
            case LIST: return new JsonArray(f.listValue().map(LentaEventLogger::getJsonValue));
        }
        return JsonString.valueOf(f.toString());
    }

    public static void log(LentaBlockEvent event) {
        LentaBlockEventsCache.addIfNeeded(event);
        logger.log(event.logData());
    }
}
