package ru.yandex.chemodan.app.lentaloader.memories;

import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author yashunsky
 */
public abstract class AbstractMemoriesCronTask extends CronTask {

    protected final MemoriesRoutines memoriesRoutines;
    protected final int executionHour;

    public AbstractMemoriesCronTask(MemoriesRoutines memoriesRoutines, int executionHour) {
        Validate.isTrue(executionHour >= 0 && executionHour < 24);
        this.memoriesRoutines = memoriesRoutines;
        this.executionHour = executionHour;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleCron("0 " + executionHour + " * * *", MoscowTime.TZ), 24);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_CRON;
    }
}
