package ru.yandex.chemodan.app.lentaloader.memories;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.lentaloader.YtPathsUtils;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author messiahlap
 */
public class CollectUidsWithBlocksTask extends OnetimeTaskSupport<CollectUidsWithBlocksTask.Parameters> {

    public static final TaskQueueName SET_MEMORIES_BLOCKS_QUEUE = new TaskQueueName("set-memories-blocks");

    private MemoriesRoutines memoriesRoutines;

    public CollectUidsWithBlocksTask(YPath path, long lowerRowIndex, long upperRowIndex) {
        super(new Parameters(path.toString(), lowerRowIndex, upperRowIndex));
    }

    public CollectUidsWithBlocksTask(MemoriesRoutines memoriesRoutines) {
        super(Parameters.class);
        this.memoriesRoutines = memoriesRoutines;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        YPath pathWithRange = YPath.simple(parameters.memoriesInfoYtPath)
                .withRange(parameters.lowerRowIndex, parameters.upperRowIndex);
        memoriesRoutines.scheduleMemoriesBlocksCreationWithStats(pathWithRange,
                YtPathsUtils.getTableDateFromPath(parameters.memoriesInfoYtPath).getOrThrow(IllegalArgumentException::new));
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public TaskQueueName queueName() {
        return SET_MEMORIES_BLOCKS_QUEUE;
    }

    @BenderBindAllFields
    public static class Parameters extends DefaultObject {
        public final String memoriesInfoYtPath;
        public final long lowerRowIndex;
        public final long upperRowIndex;

        public Parameters(String memoriesInfoYtPath, long lowerRowIndex, long upperRowIndex) {
            this.memoriesInfoYtPath = memoriesInfoYtPath;
            this.lowerRowIndex = lowerRowIndex;
            this.upperRowIndex = upperRowIndex;
        }
    }
}
