package ru.yandex.chemodan.app.lentaloader.memories;

import java.util.concurrent.TimeUnit;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.lentaloader.LentaYtContextConfiguration;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.yt.kosher.Yt;

/**
 * @author yashunsky
 */
@Configuration
@Import({LentaYtContextConfiguration.class})
public class MemoriesContextConfiguration {

    @Value("${lenta-worker.memories.yt.operation.retry.count}")
    private int ytOperationRetryCount;

    @Value("${lenta-worker.memories.yt.operation.retry.delay}")
    private Duration ytOperationRetryDelay;

    @Value("${lenta-worker.memories.schedule-cron-task.future-offset.days}")
    private int futureOffsetDays;

    @Bean
    public MemoriesRoutines memoriesRoutines(
            YtHelper memoriesYtHelper,
            @Value("${lenta-worker.memories.yt.schedule-batch-size}")
            int scheduleBatchSize,
            BazingaTaskManager bazingaTaskManager,
            UserTimezoneHelper userTimezoneHelper,
            ExperimentsManager experimentsManager,
            @Value("${lenta-worker.memories.yt.search-table-in-past.limit}")
            int limitToSearchTableInThePast,
            @Value("${lenta-worker.memories.remind-photos.schedule.errors.rate.percent}")
            int errorRateForRemindPhotosPercents,
            @Value("${lenta-worker.memories.remind-photos.schedule.retry-count}")
            int scheduleRemindPhotoRetryCount,
            @Value("${lenta-worker.memories.collect-uids-with-blocks.schedule.errors.rate.percent}")
            int errorRateForCollectUsersWithBlocksPercents
    )
    {
        return new MemoriesRoutines(memoriesYtHelper, scheduleBatchSize, bazingaTaskManager,
                userTimezoneHelper, experimentsManager,
                limitToSearchTableInThePast, errorRateForRemindPhotosPercents, scheduleRemindPhotoRetryCount,
                errorRateForCollectUsersWithBlocksPercents, futureOffsetDays);
    }

    @Bean
    public CollectUidsWithBlocksTask collectUidsWithBlocksTask(MemoriesRoutines memoriesRoutines) {
        return new CollectUidsWithBlocksTask(memoriesRoutines);
    }

    @Bean
    public MemoriesScheduleCronTask memoriesScheduleCronTask(
            MemoriesRoutines memoriesRoutines,
            @Value("${lenta-worker.memories.schedule-cron-task.execution-hour}")
                    int executionHour)
    {
        return new MemoriesScheduleCronTask(memoriesRoutines, executionHour, futureOffsetDays);
    }

    @Bean
    public RetryPolicy ytMemoriesOperationRetryPolicy() {
        return new RetryPolicy()
                .withMaxRetries(ytOperationRetryCount)
                .withDelay(ytOperationRetryDelay.getMillis(), TimeUnit.MILLISECONDS);
    }

    @Bean
    public YtHelper memoriesYtHelper(Yt ytClient, RetryPolicy ytMemoriesOperationRetryPolicy) {
        return new YtHelper(ytClient, ytMemoriesOperationRetryPolicy);
    }
}
