package ru.yandex.chemodan.app.lentaloader.memories;

import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author yashunsky
 */
public class MemoriesScheduleCronTask extends AbstractMemoriesCronTask {

    private final int futureOffsetDays;


    public MemoriesScheduleCronTask(MemoriesRoutines memoriesRoutines, int executionHour, int futureOffsetDays) {
        super(memoriesRoutines, executionHour);
        this.futureOffsetDays = futureOffsetDays;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        memoriesRoutines.scheduleMemoriesSetFromUidWithBlocks(LocalDate.now(), futureOffsetDays);
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(5);
    }
}
