package ru.yandex.chemodan.app.lentaloader.memories;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.junit.Test;
import org.mockito.ArgumentMatcher;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.lentaloader.YtPathsUtils;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.Cypress;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.test.Assert;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.Mockito.doAnswer;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class MemoryRoutinesYtTest {

    @Test
    public void testCollectUidsWithBlocks() {

        ListF<CollectUidsWithBlocksTask> tasks = Cf.arrayList();
        int batchSize = 1000;
        LocalDate yesterday = LocalDate.now().minusDays(1);

        Yt yt = mock(Yt.class);
        Cypress cypress = mock(Cypress.class);
        when(yt.cypress()).thenReturn(cypress);
        YPath yesterdayTablePath = YtPathsUtils.getCoolLentaUserWithBlocksYPath().child(yesterday.toString());
        when(cypress.exists(argThat(isMatchPath(YtPathsUtils.getCoolLentaUserWithBlocksYPath().toString())))).thenReturn(true);
        YPath dayBeforeYesterdayTablePath = YtPathsUtils.getCoolLentaUserWithBlocksYPath().child(yesterday.minusDays(1).toString());
        YTreeNode isProcessed = mock(YTreeNode.class);
        when(isProcessed.boolValue()).thenReturn(true);
        YTreeNode isNotProcessed = mock(YTreeNode.class);
        when(isNotProcessed.boolValue()).thenReturn(false);
        YTreeNode rowCounter = mock(YTreeNode.class);
        when(rowCounter.longValue()).thenReturn(18123456L);
        when(cypress.get(argThat(isMatchPath(YtPathsUtils.getCoolLentaUserWithBlocksYPath().toString()))))
                .thenAnswer(invocation -> {
                    String path = invocation.getArgument(0).toString();
                    if (path.endsWith(MemoriesRoutines.UIDS_WITH_BLOCKS_PROCESSED_ATTRIBUTE)) {
                        if (path.startsWith(dayBeforeYesterdayTablePath.toString())) {
                            return isProcessed;
                        }
                        return isNotProcessed;
                    }
                    if (path.startsWith(yesterdayTablePath.toString())) {
                        return rowCounter;
                    }
                    return null;
                });

        BazingaTaskManager mockBazingaTaskManager = mock(BazingaTaskManager.class);
        doAnswer(invocation -> {
            CollectUidsWithBlocksTask task = invocation.getArgument(0);
            tasks.add(task);
            return null;
        }).when(mockBazingaTaskManager).schedule(any(CollectUidsWithBlocksTask.class), any(Instant.class));

        MemoriesRoutines mr = new MemoriesRoutines(new YtHelper(yt, new RetryPolicy()), batchSize, mockBazingaTaskManager,
                null, null, 2, 5, 3, 10, 3);

        mr.scheduleMemoriesSetFromUidWithBlocks(LocalDate.now(), 3);

        ListF<CollectUidsWithBlocksTask> tasksTyped = tasks;
        Assert.equals(0L, tasksTyped.map(task -> task.getParametersTyped().lowerRowIndex).min());
        Assert.equals(18123456L, tasksTyped.map(task -> task.getParametersTyped().upperRowIndex).max());
        Assert.equals(tasks.size(), 18124);

    }

    private ArgumentMatcher<YPath> isMatchPath(String path) {
        return yPath -> yPath.toString().startsWith(path);
    }

}
