package ru.yandex.chemodan.app.lentaloader.reminder;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.spring.Service;

/**
 * @author tolmalev
 */
public class Cvi2tProcessor implements Service {
    private final MapF<String, byte[]> textVectors = Cf.hashMap();
    private final DiskSearchClient client;
    private final ListF<String> startWords;

    public Cvi2tProcessor(DiskSearchClient client, ListF<String> startWords) {
        this.client = client;
        this.startWords = startWords;
    }

    public Tuple2List<DiskSearchFileInfo, ListF<Long>> dotProduct(ListF<DiskSearchFileInfo> fileInfos,
            ListF<String> words)
    {
        return fileInfos.zipWith(fileInfo -> dotProduct(fileInfo.geti2tVector(), words));
    }

    public ListF<Long> dotProduct(DiskSearchFileInfo fileInfo, ListF<String> words) {
        return dotProduct(fileInfo.geti2tVector(), words);
    }

    public ListF<Long> dotProduct(byte[] a, ListF<String> words) {
        return words.map(word -> dotProduct(a, word));
    }

    public long dotProduct(byte[] a, String text) {
        return dotProduct(a, getTextVector(text));
    }

    public static long dotProduct(byte[] a, byte[] b) {
        long result = 0;
        Validate.sameSize(a, b);
        for (int i = 0; i < a.length; i++) {
            result += ((int) a[i] * (int) b[i]);
        }
        return result;
    }

    public byte[] getTextVector(String text) {
        return textVectors.getOrElseUpdate(text, () -> client.getTextCvVectors(Cf.list(text))
                .getOrThrow(text, () -> "Failed to get cv vector for text " + text)
        );
    }

    @Override
    public void start() throws Exception {
        textVectors.putAll(client.getTextCvVectors(startWords));
    }

    @Override
    public void stop() throws Exception {

    }
}
