package ru.yandex.chemodan.app.lentaloader.reminder;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author dbrylev
 */
@Configuration
public class DiskSearchClientContextConfiguration {

    @Bean
    @OverridableValuePrefix("search")
    public HttpClientConfigurator searchHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public DiskSearchClient diskSearchClient(@Value("${search.clusterizer.url}") String searchUrl) {
        return new DiskSearchClient(searchHttpClientConfigurator().configure(), searchUrl);
    }

    @Bean
    public Cvi2tProcessor cvi2tProcessor(DiskSearchClient diskSearchClient,
            @Value("${search.cv.words:-}") String startWords)
    {
        return new Cvi2tProcessor(diskSearchClient, Cf.list(startWords.split(",")));
    }

}
