package ru.yandex.chemodan.app.lentaloader.reminder;

import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author tolmalev
 */
public class DiskSearchClientTest {
    DiskSearchClient client = new DiskSearchClient(
            ApacheHttpClientUtils.singleConnectionClient(Timeout.seconds(10)),
            "http://disksearch-test.n.yandex-team.ru");

    @Test
    public void buildUrl() {
        Assert.equals("http://disksearch-test.n.yandex-team.ru/listing?uid=123" +
                "&from-etime=12345" +
                "&to-etime=67891" +
                "&mimetype=image%2Fjpeg" +
                "&mimetype=image%2Fheif" +
                "&mediatype=9&length=5&" +
                "get=id%2Cname%2Clatitude%2Clongitude%2Cetime%2Cbeautiful%2Ccost_disk_aethetic_0%2Caux_folder%2Ci2t_keyword%2Cmd5%2Cwidth%2Cheight%2Cbinary_porn%2Cmobile_porn%2Cgruesome" +
                "&skip-nulls=true" +
                "&sort=etime", client
                .buildPhotoSearchUrl(new PassportUid(123), new InstantInterval(12345000, 67891000), 5));

        Assert.equals("http://disksearch-test.n.yandex-team.ru/listing?uid=123&from-etime=12345&to-etime=67891" +
                "&mimetype=image%2Fjpeg&mimetype=image%2Fheif&mediatype=9&offset=0&length=100" +
                "&skip-nulls=true" +
                "&get=id%2Cname%2Clatitude%2Clongitude%2Cetime%2Cbeautiful%2Ccost_disk_aethetic_0%2Caux_folder%2Ci2t_keyword%2Cmd5%2Cwidth%2Cheight%2Cbinary_porn%2Cmobile_porn%2Cgruesome" +
                "&search-qualifier=cool-lenta", client
                .buildBeautySearchUrl(new PassportUid(123), new InstantInterval(12345000, 67891000), Option.of("cool-lenta"),
                        "http://disksearch-test.n.yandex-team.ru", 0, 100));
    }

    @Test
    @Ignore
    @YaIgnore //uses mpfs (Read timed out)
    //TODO: fix it (mock?)
    public void findPhotos() {
        // login testcontest00
        // password asdfg12345
        // folder /disk/lenta_reminder_test
        // to check files go to web disk.dst.yandex.ru
        // or call http://mpfs-stable.dst.yandex.net/json/list?uid=3000077416&path=/disk/lenta_reminder_test&meta=file_id

        DiskSearchResponse response =
                client.findPhotos(new PassportUid(3000077416L),
                        new InstantInterval(1474126787000L, 1474144511000L), 1000);

        Assert.equals(4L, response.hitsCount);
        Assert.sizeIs(4, response.hitsArray);
        Assert.equals(
                Cf.set("0a081c447599edc14d9f813ea1f8ddfc34b1839c52e68385850d96cab687fa7d",
                        "152a85db4fd0ba51acdf789e4415802203532a0959f8ce9fbc62ef4c3600846e",
                        "856ef103416d12078303b4437a0a7b7bf1fa04054d9224dfc6925e05838b504d",
                        "a03a3aec3498189e1551c54f17a4b7ef1b102cce7c4c57681f2fbf9ff4685b0f"),
                response.hitsArray.map(r -> r.id).unique()
        );
    }

    @Test
    @Ignore
    @YaIgnore
    public void findTotalCount() {
        Assert.ge(client.findPhotosliceDocumentsCount(new PassportUid(3000077416L)), 4L);
    }

    @Test
    public void parseWithI2tKeyword() {
        String json = "{\"hitsCount\":1,\"hitsArray\":[{\"id\":\"7ac1cdbdbb68e97f7b430c8d39e0fb9050c2ef6c0da7389e4e0e9cfc95ad00ec\",\"name\":\"071117stdc32.jpg\",\"key\":\"/disk/Фото/2007_11_17_zvesd/071117stdc32.jpg\",\"latitude\":null,\"longitude\":null,\"etime\":\"1195296328\",\"beautiful\":\"0.106624\",\"cost_disk_aethetic_0\":\"3.64719\",\"aux_folder\":\"disk\",\"i2t_keyword\":[-5,7,6,1,-8,7,-3,0,-16,19,-11,-4,-21,-8,2,1,0,0,4,6,1,-1,9,14,1,4,0,-3,15,11,-2,18,12,0,-1,-4,3,12,-8,-1,6,2,-6,7,1,16,7,4,-2,-17,-15,7,-1,6,-23,0,-9,17,15,11,6,0,-1,18,3,6,-15,1,-1,5,0,2,-8,0,13,8,3,-8,11,2,-7,-4,-12,1,-5,2,-8,-13,-7,9,-10,8,9,10,1,6,8,0,0,20,-13,8,-7,4,0,-4,-3,10,4,-10,-1,-4,10,4,-1,2,2,-20,6,22,-9,-2,-3,14,0,8,-4,12,-5,6,4,-4,-6,4,-6,-8,-13,-14,-2,13,9,3,-8,5,-10,-12,3,-9,14,13,0,12,15,-8,-12,-1,-7,-7,0,-6,-8,7,-7,2,2,0,-3,8,-11,-1,-4,23,15,-11,-5,-3,2,3,-11,8,-1,16,3,2,-8,3,0,3,0,0,-5,21,6,6,4,-8,-12,-2,2,9]}]}";
        DiskSearchClient.parseResponseJson(json);
    }

    @Test
    public void parseWithoutI2tKeyword() {
        String json = "{\"hitsCount\":1,\"hitsArray\":[{\"id\":\"7ac1cdbdbb68e97f7b430c8d39e0fb9050c2ef6c0da7389e4e0e9cfc95ad00ec\",\"name\":\"071117stdc32.jpg\",\"key\":\"/disk/Фото/2007_11_17_zvesd/071117stdc32.jpg\",\"latitude\":null,\"longitude\":null,\"etime\":\"1195296328\",\"beautiful\":\"0.106624\",\"cost_disk_aethetic_0\":\"3.64719\",\"aux_folder\":\"disk\"}]}";
        DiskSearchClient.parseResponseJson(json);
    }
}
