package ru.yandex.chemodan.app.lentaloader.reminder;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 */
@Data
@BenderBindAllFields
public class DiskSearchFileInfo {
    public final String id;
    public final String name;
    public final Option<String> ext;
    public final Option<Double> latitude;
    public final Option<Double> longitude;
    public final Option<Double> beautiful;
    @BenderPart(name = "cost_disk_aethetic_0", strictName = true)
    public final Option<Double> beautiful2;
    public final Option<Long> etime;
    @BenderPart(name = "i2t_keyword", wrapperName = "i2t_keyword", strictName = true)
    public final ListF<Byte> i2tKeyword;

    @BenderPart(name = "binary_porn", strictName = true)
    public final Option<Double> binaryPorn;
    @BenderPart(name = "mobile_porn", strictName = true)
    public final Option<Double> mobilePorn;
    @BenderPart(name = "gruesome", strictName = true)
    public final Option<Double> gruesome;

    public final Option<String> key;
    @BenderPart(name = "aux_folder", strictName = true)
    public final String auxFolder;

    public final Option<Integer> width;
    public final Option<Integer> height;

    public final Option<String> md5;

    public boolean isInDisk() {
        return "disk".equals(auxFolder);
    }

    public boolean isInPhotounlim() {
        return "photounlim".equals(auxFolder);
    }

    public boolean isInDiskOrPhotounlim() {
        return isInDisk() || isInPhotounlim();
    }

    public ListF<Double> getGeoCoordinates() {
        return latitude.isPresent() && longitude.isPresent() ? latitude.plus(longitude) : Cf.list();
    }

    public byte[] geti2tVector() {
        return i2tKeyword.toByteArray();
    }

    public boolean hasGeo() {
        return latitude.isPresent() && longitude.isPresent();
    }
}
