package ru.yandex.chemodan.app.lentaloader.reminder;

import lombok.Data;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleNever;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GenerateBlockTask extends OnetimeTaskSupport<GenerateBlockTask.Parameters> {

    private CoolLentaReminder coolLentaReminder;

    private UserTimezoneHelper userTimezoneHelper;

    public GenerateBlockTask(DataApiUserId uid, int count, Instant userTime) {
        super(new Parameters(uid, count, userTime));
    }

    public GenerateBlockTask(CoolLentaReminder coolLentaReminder,
            UserTimezoneHelper userTimezoneHelper) {
        super(Parameters.class);
        this.coolLentaReminder = coolLentaReminder;
        this.userTimezoneHelper = userTimezoneHelper;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        PassportUid uid = parameters.getUid().toPassportUid();
        DateTime userDateTime = new DateTime(parameters.getUserTime(), userTimezoneHelper.getUserTimezone(uid));
        coolLentaReminder.sendBlockNow(uid, userDateTime, parameters.getCount());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_REGULAR;
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleNever();
    }

    @Data
    @BenderBindAllFields
    public static class Parameters {

        private final DataApiUserId uid;

        private final int count;

        private final Instant userTime;
    }
}
