package ru.yandex.chemodan.app.lentaloader.reminder;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.support.I18nRecordField;
import ru.yandex.chemodan.app.dataapi.support.RecordField;

/**
 * @author messiahlap
 */
public interface MordaPhotoSelectionFields {

    RecordField<String> GENERATION_TYPE = RecordField.string("generation_type");
    RecordField<Instant> PHOTOSLICE_DATE = RecordField.instant("photoslice_date");
    RecordField<ListF<String>> RESOURCE_IDS = RecordField.list(RecordField.string("resource_ids"));
    RecordField<String> BEST_RESOURCE_ID = RecordField.string("best_resource_id");
    RecordField<Instant> MIN_DATE = RecordField.instant("min_date");
    RecordField<Instant> MAX_DATE = RecordField.instant("max_date");
    RecordField<Instant> MTIME = RecordField.instant("mtime");

    RecordField<String> USER_TIMEZONE_ID = RecordField.string("user_timezone_id");

    RecordField<String> SUBTYPE = RecordField.string("subtype");

    I18nRecordField<String> TITLE = I18nRecordField.string("title");
    I18nRecordField<String> SUBTITLE = I18nRecordField.string("subtitle");
    I18nRecordField<String> PHOTOSLICE_LINK_TEXT = I18nRecordField.string("photoslice_link_text");

    RecordField<String> GNC_TEMPLATE_NAME = RecordField.string("gnc_template_name");
    RecordField<String> GNC_GROUP_KEY = RecordField.string("gnc_group_key");
}
