package ru.yandex.chemodan.app.lentaloader.reminder;

import java.util.List;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.lentaloader.LentaBlocksContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.ThemeRegistryContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaConfigurationManager;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager;
import ru.yandex.chemodan.app.lentaloader.cool.MordaPushManager;
import ru.yandex.chemodan.app.lentaloader.cool.SupClient;
import ru.yandex.chemodan.app.lentaloader.cool.generator.CoolLentaBlockGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.generator.ThemeDefinitionRegistry;
import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TankerTextGenerator;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaNotificationManager;
import ru.yandex.chemodan.app.lentaloader.reminder.sendpush.CoolLentaBlockSendPushManager;
import ru.yandex.chemodan.app.lentaloader.reminder.sendpush.GncClient;
import ru.yandex.chemodan.app.lentaloader.reminder.titles.AbstractCoolLentaBlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.reminder.titles.CoolLentaBlockTitlesManager;
import ru.yandex.chemodan.app.lentaloader.reminder.titles.DefaultCoolLentaBlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.reminder.titles.GeoCoolLentaBlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.reminder.titles.NYearsAgoCoolLentaBlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.reminder.titles.SpecialDateTitleConfigurationRegistry;
import ru.yandex.chemodan.app.lentaloader.reminder.titles.ThematicCoolLentaBlockTitlesGenerator;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.commune.bazinga.impl.storage.BazingaStorage;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.inside.geobase.Geobase6;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        DiskSearchClientContextConfiguration.class,
        ThemeRegistryContextConfiguration.class,
        LentaBlocksContextConfiguration.class

})
public class PhotoReminderContextConfiguration {

    @Value("${remind.cool-lenta.repeat_timeout}")
    private Duration minRepeatDuration;

    @Bean
    public PhotoReminderManager photoReminderManager(UserTimezoneHelper userTimezoneHelper,
            ExperimentsManager experimentsManager, CoolLentaReminder coolLentaReminder,
            CoolLentaConfigurationManager coolLentaConfigurationManager)
    {
        return new PhotoReminderManager(userTimezoneHelper, experimentsManager, coolLentaReminder, coolLentaConfigurationManager);
    }

    @Bean
    public CoolLentaReminder coolLentaReminder(CoolLentaManager coolLentaManager, LentaManager lentaManager,
            LentaNotificationManager lentaNotificationManager,
            @Value("${remind.cool-lenta.min_lifetime}") Duration minBlockLifetime,
            @Value("${remind.cool-lenta.last_blocks_for_thematic_check_count}") int lastBlocksCountForThematicCheck,
            Cvi2tProcessor cvi2tProcessor,
            ExperimentsManager experimentsManager, ThemeDefinitionRegistry themeDefinitionRegistry,
            List<CoolLentaBlockGenerator> blockGenerators, CoolLentaBlockTitlesManager coolLentaBlockTitlesManager,
            CoolLentaBlockSendPushManager coolLentaBlockSendPushManager, UserTimezoneHelper userTimezoneHelper,
            CoolLentaConfigurationManager coolLentaConfigurationManager, DataApiManager dataApiManager,
            MordaPushManager mordaPushManager, Blackbox2 blackbox2, GncClient lentaGncClient)
    {
        return new CoolLentaReminder(coolLentaManager, lentaManager, lentaNotificationManager,
                cvi2tProcessor, experimentsManager, themeDefinitionRegistry,
                Cf.toList(blockGenerators), minRepeatDuration, minBlockLifetime,
                lastBlocksCountForThematicCheck, coolLentaBlockTitlesManager, coolLentaBlockSendPushManager, userTimezoneHelper,
                coolLentaConfigurationManager, dataApiManager, mordaPushManager, blackbox2, lentaGncClient);
    }

    @Bean
    public GncClient lentaGncClient(MpfsClient mpfsClient, CoolLentaConfigurationManager coolLentaConfigurationManager,
                                    SupClient supClient, Blackbox2 blackbox2, DataApiManager dataApiManager, CoolLentaManager coolLentaManager) {
        return new GncClient(supClient, mpfsClient, coolLentaConfigurationManager, blackbox2, dataApiManager, coolLentaManager);
    }

    @Bean
    public RemindPhotosTask remindPhotosTask(PhotoReminderManager photoReminderManager) {
        return new RemindPhotosTask(photoReminderManager);
    }

    @Bean
    public PhotoReminderTaskManager photoReminderTaskManager(BazingaStorage bazingaStorage,
            ExperimentsManager experimentsManager, LentaManager lentaManager, UserTimezoneHelper userTimezoneHelper)
    {
        return new PhotoReminderTaskManager(bazingaStorage, experimentsManager, lentaManager, userTimezoneHelper);
    }

    @Bean
    public RemoveAutouploadBlockNotification removeAutouploadBlockNotification(PhotoReminderTaskManager photoReminderTaskManager) {
        return new RemoveAutouploadBlockNotification(photoReminderTaskManager);
    }

    @Bean
    public GenerateBlockTask generateBlockTask(CoolLentaManager coolLentaManager, CoolLentaReminder coolLentaReminder,
            UserTimezoneHelper userTimezoneHelper) {
        return new GenerateBlockTask(coolLentaReminder, userTimezoneHelper);
    }

    @Bean
    public SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry(@Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager) {
        SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry =
                new SpecialDateTitleConfigurationRegistry(zkRoot.child("cool-lenta-reminder-special-dates"));
        zkManager.addClient(specialDateTitleConfigurationRegistry);
        return specialDateTitleConfigurationRegistry;
    }

    @Bean
    public DefaultCoolLentaBlockTitlesGenerator defaultCoolLentaBlockTitlesGenerator(TankerTextGenerator tankerTextGenerator,
            BlockTitlesGenerator blockTitlesGenerator, SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry,
            ExperimentsManager experimentsManager)
    {
        return new DefaultCoolLentaBlockTitlesGenerator(specialDateTitleConfigurationRegistry, tankerTextGenerator,
                blockTitlesGenerator, experimentsManager);
    }

    @Bean
    public NYearsAgoCoolLentaBlockTitlesGenerator nYearsAgoCoolLentaBlockTitlesGenerator(TankerTextGenerator tankerTextGenerator,
            BlockTitlesGenerator blockTitlesGenerator, SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry,
            ExperimentsManager experimentsManager)
    {
        return new NYearsAgoCoolLentaBlockTitlesGenerator(specialDateTitleConfigurationRegistry, tankerTextGenerator,
                blockTitlesGenerator, experimentsManager);
    }

    @Bean
    public ThematicCoolLentaBlockTitlesGenerator thematicCoolLentaBlockTitlesGenerator(TankerTextGenerator tankerTextGenerator,
            BlockTitlesGenerator blockTitlesGenerator, SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry,
            ThemeDefinitionRegistry themeDefinitionRegistry, ExperimentsManager experimentsManager) {
        return new ThematicCoolLentaBlockTitlesGenerator(specialDateTitleConfigurationRegistry, tankerTextGenerator,
                blockTitlesGenerator, experimentsManager, themeDefinitionRegistry);
    }

    @Bean
    public GeoCoolLentaBlockTitlesGenerator geoCoolLentaBlockTitlesGenerator(TankerTextGenerator tankerTextGenerator,
            BlockTitlesGenerator blockTitlesGenerator, SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry,
            Geobase6 geobase6, ExperimentsManager experimentsManager)
    {
        return new GeoCoolLentaBlockTitlesGenerator(specialDateTitleConfigurationRegistry, tankerTextGenerator, blockTitlesGenerator,
                geobase6, experimentsManager);
    }

    @Bean
    public CoolLentaBlockTitlesManager coolLentaBlockTitlesManager(List<AbstractCoolLentaBlockTitlesGenerator> coolLentaBlockTitlesGenerators) {
        return new CoolLentaBlockTitlesManager(Cf.x(coolLentaBlockTitlesGenerators));
    }

    @Bean
    public CoolLentaBlockSendPushManager coolLentaBlockSendPushManager(@Value("${remind.cool-lenta.burst_count}") int burstBlocksCount) {
        return new CoolLentaBlockSendPushManager((int) minRepeatDuration.getStandardDays(), burstBlocksCount);
    }
}
