package ru.yandex.chemodan.app.lentaloader.reminder;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.support.RecordField;

/**
 * @author dbrylev
 */
public interface PhotoReminderFields {
    RecordField<Integer> YEARS_AGO = RecordField.intNumber("years_ago");
    RecordField<Instant> BEAUTY_PERIOD_START = RecordField.instant("beauty_period_start");
    RecordField<ListF<String>> RESOURCE_IDS = RecordField.list(RecordField.string("resource_ids"));

    RecordField<Instant> INTERVAL_START = RecordField.instant("interval_start");
    RecordField<Instant> INTERVAL_END = RecordField.instant("interval_end");

    RecordField<ListF<ListF<Double>>> GEO_COORDINATES =
            RecordField.list(RecordField.list(RecordField.decimal("geo_coordinates")));

    RecordField<ReminderNotificationType> NOTIFICATION_TYPE =
            RecordField.stringEnum("notification_type", ReminderNotificationType.class);
}
