package ru.yandex.chemodan.app.lentaloader.reminder;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.FieldPredicate;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;
import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.commune.bazinga.impl.JobInfoValue;
import ru.yandex.commune.bazinga.impl.JobStatus;
import ru.yandex.commune.bazinga.impl.OnetimeJob;
import ru.yandex.commune.bazinga.impl.storage.BazingaStorage;
import ru.yandex.inside.passport.PassportUid;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * @author messiahlap
 */
public class PhotoReminderTaskManagerTest {

    private static final long UID = 1L;

    private static final PassportUid PUID = PassportUid.cons(UID);

    private final BazingaStorage bazingaStorage = mock(BazingaStorage.class);

    private final ExperimentsManager experimentsManager = mock(ExperimentsManager.class);

    private final LentaManager lentaManager = mock(LentaManager.class);

    private final UserTimezoneHelper userTimezoneHelper = mock(UserTimezoneHelper.class);

    private final PhotoReminderTaskManager photoReminderTaskManager = new PhotoReminderTaskManager(bazingaStorage, experimentsManager,
            lentaManager, userTimezoneHelper);

    @Before
    public void initMocks() {
        OnetimeJob job = mock(OnetimeJob.class);
        JobInfoValue jobInfoValue = mock(JobInfoValue.class);
        when(jobInfoValue.getStatus()).thenReturn(JobStatus.READY);
        when(job.getValue()).thenReturn(jobInfoValue);
        when(bazingaStorage.findOnetimeJobByActiveUid(anyString())).thenReturn(Option.of(job));

        when(experimentsManager.getFlags(UID)).thenReturn(Cf.list(PhotoReminderTaskManager.COOL_LENTA_REMOVE_PUSH_FOR_AUTOUPLOAD_EXPERIMENT));

        when(lentaManager.findBlocks(any(DataApiUserId.class), eq(LentaRecordType.CONTENT_BLOCK), any(FieldPredicate.class), any(ActionInfo.class)))
                .thenReturn(Cf.list(createLentaBlockRecord()));

        when(userTimezoneHelper.getUserTimezone(PUID)).thenReturn(DateTimeZone.getDefault());
    }

    @Test
    public void test() {
        Assert.assertTrue(photoReminderTaskManager.deleteAddNotificationForAutouploadTaskForBlock(PUID, Instant.now()));
    }

    private LentaBlockRecord createLentaBlockRecord() {
        Instant now = Instant.now();
        return new LentaBlockRecord("1", 1L, LentaRecordType.CONTENT_BLOCK, "", Option.empty(), now, Option.of(now), Cf.map());
    }
}
