package ru.yandex.chemodan.app.lentaloader.reminder;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.support.I18nRecordField;
import ru.yandex.chemodan.app.dataapi.support.RecordField;

/**
 * @author dbrylev
 */
public interface PhotoSelectionFields {
    RecordField<Instant> PHOTOSLICE_DATE = RecordField.instant("photoslice_date");
    RecordField<ListF<String>> RESOURCE_IDS = RecordField.list(RecordField.string("resource_ids"));
    RecordField<String> BEST_RESOURCE_ID = RecordField.string("best_resource_id");

    RecordField<Instant> INTERVAL_START = RecordField.instant("interval_start");
    RecordField<Instant> INTERVAL_END = RecordField.instant("interval_end");
    RecordField<String> USER_TIMEZONE_ID = RecordField.string("user_timezone_id");
    RecordField<Instant> USER_GENERATION_TIME = RecordField.instant("user_generation_time");

    RecordField<ListF<ListF<Double>>> GEO_COORDINATES =
            RecordField.list(RecordField.list(RecordField.decimal("geo_coordinates")));

    RecordField<PhotoSelectionNotificationType> NOTIFICATION_TYPE =
            RecordField.stringEnum("notification_type", PhotoSelectionNotificationType.class);

    RecordField<String> SUBTYPE = RecordField.string("subtype");
    RecordField<String> ENABLED_PLATFORMS = RecordField.string("enabled_platforms");
    RecordField<String> ICON_TYPE = RecordField.string("icon_type");

    I18nRecordField<String> TITLE = I18nRecordField.string("title");

    I18nRecordField<String> COVER_TITLE = I18nRecordField.string("cover_title");
    I18nRecordField<String> COVER_SUBTITLE = I18nRecordField.string("cover_subtitle");
    I18nRecordField<String> BUTTON_TEXT = I18nRecordField.string("button_text");

    RecordField<ListF<Integer>> GEO_REGION_IDS = RecordField.list(RecordField.intNumber("geo_region_ids"));

    RecordField<String> DESKTOP_URL = RecordField.string("desktop_url");
}
