package ru.yandex.chemodan.app.lentaloader.reminder;

import javax.annotation.Nullable;

import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class RemoveAutouploadBlockNotification extends OnetimeTaskSupport<RemoveAutouploadBlockNotification.Parameters> {

    private PhotoReminderTaskManager photoReminderTaskManager;

    public RemoveAutouploadBlockNotification(PhotoReminderTaskManager photoReminderTaskManager) {
        super(Parameters.class);
        this.photoReminderTaskManager = photoReminderTaskManager;
    }

    public RemoveAutouploadBlockNotification(PassportUid uid, Instant userNow) {
        super(new Parameters(uid, userNow));
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        photoReminderTaskManager.deleteAddNotificationForAutouploadTaskForBlock(parameters.getUid(), parameters.getUserNow());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_REGULAR;
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }

    @Data
    @BenderBindAllFields
    public static class Parameters {

        private final PassportUid uid;

        private final Instant userNow;

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, ActiveUid> {
            @Override
            public Class<ActiveUid> getActiveUniqueIdentifierClass() {
                return ActiveUid.class;
            }

            @Override
            public ActiveUid convert(Parameters parameters) {
                return new ActiveUid(parameters.getUid());
            }
        }
    }

    @Data
    @BenderBindAllFields
    private static class ActiveUid {
        private final PassportUid uid;
    }
}
