package ru.yandex.chemodan.app.lentaloader.reminder.photopicker;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsResourceId;

@Data
public class RemindPhoto {
    public final MpfsResourceId resourceId;
    public final Option<Double> latitude;
    public final Option<Double> longitude;

    public String serializeResourceId() {
        return resourceId.serialize();
    }

    public ListF<Double> getGeoCoordinates() {
        return latitude.isPresent() && longitude.isPresent() ? latitude.plus(longitude) : Cf.list();
    }
}
