package ru.yandex.chemodan.app.lentaloader.reminder.sendpush;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.lang.Validate;

@Data
@BenderBindAllFields
public class SupGncPayloadData {

    public static final BenderSerializer<SupGncPayloadData> serializer = MetadataWrapper.mapper.createSerializer(SupGncPayloadData.class);

    private static final String DISK_GNC_SERVICE_NAME = "disk";

    @BenderPart(wrapperName = "receiver")
    private final ListF<Receiver> receivers;

    private final Option<Integer> ttl;

    private final Option<String> project;

    @BenderPart(name = "bell_features", strictName = true)
    private final BellData bellData;

    public static SupGncPayloadData forNewNotification(PassportUid uid, String type, MetadataWrapper meta,
            String groupKey) {
        return new SupGncPayloadData(Cf.list(Receiver.uid(uid)), Option.of(3600), Option.of(DISK_GNC_SERVICE_NAME),
                BellData.forNewNotification(type, meta, groupKey));
    }

    public static SupGncPayloadData forNotificationDeletion(PassportUid uid, String type, String groupKey) {
        return new SupGncPayloadData(Cf.list(Receiver.uid(uid)), Option.empty(), Option.empty(),
                BellData.forNotificationDeletion(type, groupKey));
    }

    @BenderBindAllFields
    @Data
    public static class Receiver {

        private static final String SEPARATOR = ":";

        private final String type;

        private final String value;

        public static Receiver parse(String value) {
            Validate.isTrue(value.contains(SEPARATOR));
            String[] parts = value.split(SEPARATOR);
            Validate.isTrue(parts.length == 2);
            return new Receiver(parts[0], parts[1]);
        }

        public static Receiver uid(PassportUid uid) {
            return new Receiver("uid", uid.toString());
        }

        @BenderTextValue
        public static Receiver benderParse(String value) {
            return parse(value);
        }

        @BenderTextValue
        public String serialize() {
            return String.format("%s" + SEPARATOR + "%s", type, value);
        }
    }

    @Data
    @BenderBindAllFields
    public static class BellData {

        private final Option<String> actor;

        private final String type;

        private final String service;

        private final Option<MetadataWrapper> meta;

        @BenderPart(name = "group_key", strictName = true)
        private final String groupKey;

        public static BellData forNewNotification(String type, MetadataWrapper meta, String groupKey) {
            return new BellData(Option.of("ya_disk"), type, DISK_GNC_SERVICE_NAME, Option.of(meta), groupKey);
        }

        public static BellData forNotificationDeletion(String type, String groupKey) {
            return new BellData(Option.empty(), type, DISK_GNC_SERVICE_NAME, Option.empty(), groupKey);
        }
    }
}
