package ru.yandex.chemodan.app.lentaloader.reminder.sendpush;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.inside.passport.PassportUid;

public class SupGncPayloadDataTest {

    private static final long UID = 208983871;

    private static final String PREVIEW_URL = "https://downloader.disk.yandex.ru/preview/5d7deac2e388f975fd759d5e56070ce6" +
            "8252c0eee62b13e04109e789c43623ec/5df7ca20/Tcuiyjn70mcYFhOFZ-QZ6QItxhlo9qZRcpcdlXwJpApjqF1WzJ8_C2FoTufiMRPYXz" +
            "wGqRRejeqCq6GmNN4gEA%3D%3D?uid=208983871&filename=image.jpg&disposition=attachment&hash=&limit=0&" +
            "content_type=application%2Foctet-stream&owner_uid=208983871&tknv=v2&size=M&crop=0";

    private static final String ACTION_URL = "https://disk.yandex.ru/client/remember/000000157650582415803530000001576494932113?from=gnc";

    private static final String NEW_NOTIFICATION_RESULT_JSON = "{\"receiver\":[\"uid:208983871\"],\"ttl\":3600,\"project\":\"disk\"," +
            "\"bell_features\":{\"actor\":\"ya_disk\",\"type\":\"gnc_new_photo_selection_3\",\"service\":\"disk\"," +
            "\"meta\":{\"preview\":{\"type\":\"link\",\"link\":\"https://downloader.disk.yandex.ru/preview/5d7deac2e388f" +
            "975fd759d5e56070ce68252c0eee62b13e04109e789c43623ec/5df7ca20/Tcuiyjn70mcYFhOFZ-QZ6QItxhlo9qZRcpcdlXwJpApjqF" +
            "1WzJ8_C2FoTufiMRPYXzwGqRRejeqCq6GmNN4gEA%3D%3D?uid=208983871&filename=image.jpg&disposition=attachment&hash=" +
            "&limit=0&content_type=application%2Foctet-stream&owner_uid=208983871&tknv=v2&size=M&crop=0\"}," +
            "\"action\":{\"type\":\"link\",\"link\":\"https://disk.yandex.ru/client/remember/000000157650582415803530000001576494932113?from=gnc\"}," +
            "\"photo_selection_title\":{\"type\":\"text\",\"text\":\"Ваши лучшие снимки\"}},\"group_key\":\"208983871_new_photos_P5AVeqmJjo\"}}";

    private static final String NOTIFICATION_DELETION_RESULT_JSON = "{\"receiver\":[\"uid:208983871\"],\"bell_features\"" +
            ":{\"type\":\"gnc_new_photo_selection_3\",\"service\":\"disk\",\"group_key\":\"208983871_new_photos_P5AVeqmJjo\"}}";

    @Test
    public void testNewNotification() {
        MetadataWrapper meta = MetadataWrapper.createEmpty();
        MetadataEntity photoSelectionTitleData = new MetadataEntity(MetadataEntityType.TEXT);
        photoSelectionTitleData.put("text", "Ваши лучшие снимки");
        meta.meta.put("photo_selection_title", photoSelectionTitleData);
        meta.meta.put("action", GncClient.getMetadataLinkEntity(ACTION_URL));
        meta.meta.put("preview", GncClient.getMetadataLinkEntity(PREVIEW_URL));
        SupGncPayloadData data = SupGncPayloadData.forNewNotification(PassportUid.cons(UID), "gnc_new_photo_selection_3",
                meta, "208983871_new_photos_P5AVeqmJjo");
        String json = new String(SupGncPayloadData.serializer.serializeJson(data));
        Assert.assertNotNull(json);
        Assert.assertEquals(NEW_NOTIFICATION_RESULT_JSON, json);
    }

    @Test
    public void testNotificationDeletion() {
        MetadataWrapper meta = MetadataWrapper.createEmpty();
        MetadataEntity photoSelectionTitleData = new MetadataEntity(MetadataEntityType.TEXT);
        photoSelectionTitleData.put("text", "Ваши лучшие снимки");
        meta.meta.put("photo_selection_title", photoSelectionTitleData);
        meta.meta.put("action", GncClient.getMetadataLinkEntity(ACTION_URL));
        meta.meta.put("preview", GncClient.getMetadataLinkEntity(PREVIEW_URL));
        SupGncPayloadData data = SupGncPayloadData.forNotificationDeletion(PassportUid.cons(UID), "gnc_new_photo_selection_3",
                "208983871_new_photos_P5AVeqmJjo");
        String json = new String(SupGncPayloadData.serializer.serializeJson(data));
        Assert.assertNotNull(json);
        Assert.assertEquals(NOTIFICATION_DELETION_RESULT_JSON, json);
    }
}
