package ru.yandex.chemodan.app.lentaloader.reminder.sendpush.modeling;

import lombok.Data;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.random.Random2;

/**
 * @author messiahlap
 */
public class SendPushTest {

    private static final ListF<Integer> COUNTS = Cf.list(//
             1, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 200, 300, 500);

    private static final ListF<Integer> SENDS_COUNTS = Cf.list(3, 5, 7);

    private SendPushProcessor defaultProcessor = new SendPushProcessor(3, 3);

    private int daysCount = 150;

    private int retriesCount = 30;

    @Test
    @Ignore
    public void test() {
        for (Integer itemsCount : COUNTS) {
            for (Integer sendsCount : SENDS_COUNTS) {
                ListF<Result> results = Cf.arrayList();
                for (int i = 0; i < 3; i++) {
                    results.add(run(new SendPushProcessor(sendsCount, 3), itemsCount));
                }
                System.out.println("SendsCount=" + sendsCount + ", result=" +
                        new Result(results.map(Result::getAvgPush).reduceLeft(Cf.Double::plus) / 3,
                                results.map(Result::getAvgSend).reduceLeft(Cf.Double::plus) / 3) + ", ItemsCount=" + itemsCount);
            }
        }
    }

    private ListF<SendPushable> createItems(int itemsCount) {
        ListF<SendPushable> allItems = Cf.arrayList();
        Cf.range(0, itemsCount).forEach(index -> allItems.add(new SendPushable()));
        return allItems.unmodifiable();
    }

    private Result run(SendPushProcessor sendPushProcessor, int itemsCount) {
        int sendsCountTotal = 0;
        int pushesCountTotal = 0;
        for (int j = 0; j < retriesCount; j++) {
            ListF<SendPushable> items = createItems(itemsCount);
            DateTime initialDate = warmUp(new DateTime(2018, 4, 1, 3, 0, 0), items);
            int sendsCount = 0;
            int pushesCount = 0;
            for (int i = 0; i < daysCount; i++) {
                DateTime today = getExecutionTime(initialDate.plusDays(i));
                if (!sendPushProcessor.shouldSendToday(today, items)) {
                    continue;
                }
                Option<SendPushable> selected = sendPushProcessor.processSending(today, items);
                if (!selected.isPresent()) {
                    continue;
                }
                sendsCount++;
                if (!sendPushProcessor.shouldPushToday(today, items)) {
                    continue;
                }
                sendPushProcessor.processPush(today, selected.get());
                pushesCount++;
            }
            sendsCountTotal += sendsCount;
            pushesCountTotal += pushesCount;
        }
        return new Result((double) pushesCountTotal / (retriesCount * daysCount), (double) sendsCountTotal / (retriesCount * daysCount));
    }

    private DateTime warmUp(DateTime initialDateTime, ListF<SendPushable> allItems) {
        DateTime result = initialDateTime;
        for (int i = 0; i < daysCount; i++) {
            DateTime today = getExecutionTime(initialDateTime.plusDays(i));
            result = today;
            if (!defaultProcessor.shouldSendToday(today, allItems)) {
                continue;
            }
            Option<SendPushable> selected = defaultProcessor.processSending(today, allItems);
            if (!selected.isPresent()) {
                continue;
            }
            if (!defaultProcessor.shouldPushToday(today, allItems)) {
                continue;
            }
            defaultProcessor.processPush(today, selected.get());
        }
        return result;
    }

    private DateTime getExecutionTime(DateTime today) {
        Instant timeFrom = today.withTime(11, 0, 0, 0).toInstant();
        Instant timeTo = today.withTime(20, 0, 0, 0).toInstant();
        return new DateTime(Random2.R.nextInstant(timeFrom, timeTo));
    }

    @Data
    private static class Result {
        private final double avgPush;
        private final double avgSend;
    }
}
