package ru.yandex.chemodan.app.lentaloader.reminder.special;

import org.joda.time.DateTime;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaFileItem;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager;
import ru.yandex.chemodan.app.lentaloader.cool.generator.BlockGeneratorUtils;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TimeIntervalUtils;
import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author tolmalev
 */
public class GetStatsForNY2018 extends OnetimeTaskSupport<GetStatsForNY2018.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger("ny_2018_stats");

    private final CoolLentaManager coolLentaManager;

    public GetStatsForNY2018(CoolLentaManager coolLentaManager) {
        super(Parameters.class);
        this.coolLentaManager = coolLentaManager;
    }

    public GetStatsForNY2018(long uid) {
        super(new Parameters(PassportUid.cons(uid)));
        this.coolLentaManager = null;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        DateTime yearStart = TimeIntervalUtils.getYearStart(DateTime.now());
        DateTime yearEnd = TimeIntervalUtils.getYearEnd(DateTime.now());

        ListF<CoolLentaFileItem> allFiles =
                coolLentaManager.getFiles(parameters.uid, new InstantInterval(yearStart, yearEnd),
                        Option.of("ny-2018-stats"), -1000.0);

        Tuple2List<String, String> reportParts = Tuple2List.arrayList();
        reportParts.add("all_files", "" + allFiles.size());

        allFiles = allFiles.filter(item -> {
            if (item.newBeauty.isPresent())
                return item.newBeauty.get() > 0.16;

            if (item.oldBeauty.isPresent())
                return item.oldBeauty.get() > 1;
            return false;
        });

        reportParts.add("files_filtered_by_beauty", "" + allFiles.size());

        ListF<Integer> joinVariants = Cf.list(120, 360, 720, 1440, 3600);

        for (Integer joinInterval : joinVariants) {
            ListF<CoolLentaFileItem> groups =
                    BlockGeneratorUtils.filterByNearGroups(allFiles, joinInterval);

            reportParts.add("joined_by_" + joinInterval, "" + groups.size());
        }

        ListF<CoolLentaFileItem> smartGroups = BlockGeneratorUtils.smartJoinGroups(allFiles, 50);
        reportParts.add("joined_by_smart", "" + smartGroups.size());

        logger.info("uid={}, {}", parameters.uid, reportParts.map((k, v) -> k + "=" + v).mkString(","));
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_COOL;
    }

    @BenderBindAllFields
    static class Parameters {
        public final PassportUid uid;

        Parameters(PassportUid uid) {
            this.uid = uid;
        }
    }
}
