package ru.yandex.chemodan.app.lentaloader.reminder.titles;

import lombok.Data;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TitleGenerationContext;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author messiahlap
 */
public class CoolLentaBlockTitlesManager {

    private final ListF<AbstractCoolLentaBlockTitlesGenerator> coolLentaBlockTitlesGenerators;

    public CoolLentaBlockTitlesManager(ListF<AbstractCoolLentaBlockTitlesGenerator> coolLentaBlockTitlesGenerators) {
        this.coolLentaBlockTitlesGenerators = coolLentaBlockTitlesGenerators;
    }

    public Option<BlockTexts> generateTextsForBlock(TitleParameters titleParameters,
            BlockTitlesType blockTitlesType)
    {
        return coolLentaBlockTitlesGenerators.find(generator -> blockTitlesType == generator.getTitlesType())
                .getOrThrow("Cannot find titles generator for blockType " + blockTitlesType)
                .generateBlockTexts(titleParameters);
    }

    @Data
    public static class TitleParameters {
        private final TitleGenerationContext titleGenerationContext;
        private final LocalDate date;
        private final Option<String> themeName;
        private final PassportUid uid;
    }
}
