package ru.yandex.chemodan.app.lentaloader.reminder.titles;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TankerTextGenerator;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.inside.utils.LocalizedString;

/**
 * @author messiahlap
 */
public class DefaultCoolLentaBlockTitlesGenerator extends AbstractCoolLentaBlockTitlesGenerator {

    public DefaultCoolLentaBlockTitlesGenerator(SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry,
            TankerTextGenerator tankerTextGenerator, BlockTitlesGenerator blockTitlesGenerator, ExperimentsManager experimentsManager)
    {
        super(specialDateTitleConfigurationRegistry, tankerTextGenerator, blockTitlesGenerator, experimentsManager);
    }

    @Override
    public BlockTitlesType getTitlesType() {
        return BlockTitlesType.DEFAULT;
    }

    @Override
    protected Option<LocalizedString> getCoverTitle(CoolLentaBlockTitlesManager.TitleParameters titleParameters) {
        return Option.of(getBlockTitlesGenerator().generateBlockTitle(titleParameters.getTitleGenerationContext()));
    }
}
