package ru.yandex.chemodan.app.lentaloader.reminder.titles;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TankerTextGenerator;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.inside.utils.LocalizedString;

/**
 * @author messiahlap
 */
public class NYearsAgoCoolLentaBlockTitlesGenerator extends AbstractCoolLentaBlockTitlesGenerator {

    private static final String N_YEARS_TITLE_TEXT_TANKER_KEYS_PREFIX =
            "lenta/cool_lenta_n_years_ago_cover_title";

    public NYearsAgoCoolLentaBlockTitlesGenerator(SpecialDateTitleConfigurationRegistry specialDateTitleConfigurationRegistry,
            TankerTextGenerator tankerTextGenerator, BlockTitlesGenerator blockTitlesGenerator, ExperimentsManager experimentsManager)
    {
        super(specialDateTitleConfigurationRegistry, tankerTextGenerator, blockTitlesGenerator, experimentsManager);
    }

    @Override
    public BlockTitlesType getTitlesType() {
        return BlockTitlesType.N_YEARS;
    }

    @Override
    protected Option<LocalizedString> getCoverTitle(CoolLentaBlockTitlesManager.TitleParameters titleParameters) {
        return Option.of(getTankerTextGenerator()
                .processOneFromSetOrTemplatesByKeyPrefix(N_YEARS_TITLE_TEXT_TANKER_KEYS_PREFIX,
                        titleParameters.getTitleGenerationContext()));
    }
}
