package ru.yandex.chemodan.app.lentaloader.reminder.titles;

import java.util.concurrent.atomic.AtomicReference;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author messiahlap
 */
public class SpecialDateTitleConfigurationRegistry extends ZkRegistry<String, SpecialDateTitleConfiguration> {

    private final AtomicReference<MapF<SpecialDateTitleConfiguration.DayWithMonth, SpecialDateTitleConfiguration>> datesIndex =
            new AtomicReference(Cf.map());

    public SpecialDateTitleConfigurationRegistry(ZkPath zkPath) {
        super(zkPath, new BenderMapper().createParserSerializer(SpecialDateTitleConfiguration.class),
                SpecialDateTitleConfiguration::getSpecialDateName, Function.identityF());
        addListener(this::updateDatesIndex);
    }

    public Option<SpecialDateTitleConfiguration> getSpecialDateConfigurationForDateO(SpecialDateTitleConfiguration.DayWithMonth dayWithMonth) {
        return datesIndex.get().getO(dayWithMonth);
    }

    private void updateDatesIndex(CollectionF<SpecialDateTitleConfiguration> allConfigurations) {
        awaitInitialization();
        MapF<SpecialDateTitleConfiguration.DayWithMonth, SpecialDateTitleConfiguration> index = Cf.hashMap();
        allConfigurations.forEach(configuration -> configuration.getDates().forEach(date -> index.put(date, configuration)));
        datesIndex.set(index.unmodifiable());
    }
}
